package com.bizunited.empower.business.payment.feign.fallback;

import com.bizunited.empower.business.payment.feign.BankCardFeignClient;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.exception.ServerBusyException;
import org.springframework.stereotype.Component;

/**
 * 银行卡查询feign熔断器
 *
 * @Author: Paul Chan
 * @Date: 2021/4/14 上午11:32
 */
@Component
public class BankCardFeignClientFallback implements BankCardFeignClient {

  @Override
  public ResponseModel findByCardNumber(String appId, String sign, String cardNum) {
    throw new ServerBusyException();
  }

  @Override
  public ResponseModel addToWhiteList(String appId, String sign, String json) {
    throw new ServerBusyException();
  }

  @Override
  public ResponseModel removeFromWhiteList(String appId, String sign, String json) {
    throw new ServerBusyException();
  }
}
