package com.bizunited.empower.business.payment.feign.fallback;

import com.bizunited.empower.business.payment.feign.ElectronicAccountFeignClient;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.exception.ServerBusyException;
import org.springframework.stereotype.Component;

/**
 * 电子账户feign熔断器
 * @Author: Paul Chan
 * @Date: 2021/4/14 上午11:32
 */
@Component
public class ElectronicAccountFeignClientFallback implements ElectronicAccountFeignClient {

  @Override
  public ResponseModel handleSign(String appId, String sign, String signDto) {
    throw new ServerBusyException();
  }

  @Override
  public ResponseModel handleTiedCardVerify(String appId, String sign, String tiedCardVerifyDto) {
    throw new ServerBusyException();
  }

  @Override
  public ResponseModel handleUntieCardVerify(String appId, String sign, String tiedCardVerifyDto) {
    throw new ServerBusyException();
  }

  @Override
  public ResponseModel findVerifyAddress(String appId, String sign, String signDto) {
    return null;
  }

  @Override
  public ResponseModel updateForTiedCard(String appId, String sign, String electronicAccount) {
    throw new ServerBusyException();
  }

  @Override
  public ResponseModel handleTiedCard(String appId, String sign, String tiedCardVerifyDto) {
    throw new ServerBusyException();
  }

  @Override
  public ResponseModel updateSecurePhone(String appId, String sign, String securePhoneDto) {
    throw new ServerBusyException();
  }
}
