package com.bizunited.empower.business.payment.feign.fallback;

import com.bizunited.empower.business.payment.feign.ElectronicAccountInfoFeignClient;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.exception.ServerBusyException;
import org.springframework.stereotype.Component;

/**
 * 电子账户feign熔断器
 * @Author: Paul Chan
 * @Date: 2021/4/14 上午11:32
 */
@Component
public class ElectronicAccountInfoFeignClientFallback implements ElectronicAccountInfoFeignClient {

  @Override
  public ResponseModel create(String appId, String sign, String electronicAccount) {
    throw new ServerBusyException();
  }

  @Override
  public ResponseModel update(String appId, String sign, String electronicAccount) {
    throw new ServerBusyException();
  }


}
