package com.bizunited.empower.business.payment.feign.fallback;

import com.bizunited.empower.business.payment.feign.PaymentFeignClient;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.exception.ServerBusyException;
import org.springframework.stereotype.Component;

/**
 * 支付feign熔断器
 *
 * @Author: Paul Chan
 * @Date: 2021/4/14 上午11:32
 */
@Component
public class PaymentFeignClientFallback implements PaymentFeignClient {

  @Override
  public ResponseModel pay(String appId, String sign, String payInfo) {
    throw new ServerBusyException();
  }

  @Override
  public ResponseModel cancel(String appId, String sign, String payInfo) {
    throw new ServerBusyException();
  }
}
