package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.CustomerBank;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * CustomerBankRepository业务模型的数据库方法支持
 *
 * @author Keller
 */
@Repository("_CustomerBankRepository")
public interface CustomerBankRepository extends
        JpaRepository<CustomerBank, String>
        , JpaSpecificationExecutor<CustomerBank> {

  /**
   * 根据客户编码查询客户的信用流水记录
   * @param customerCode
   * @param pageable
   * @return
   */
  @Query("select cb from CustomerBank cb " +
          " where cb.tenantCode = :tenantCode " +
          " and cb.customerCode = :customerCode " +
          " order by cb.createTime desc ")
  Page<CustomerBank> findByTenantCodeAndCustomerCode(@Param("tenantCode") String tenantCode, @Param("customerCode") String customerCode, Pageable pageable);

  /**
   * 根据客户编码查询客户的信用流水记录
   * @param customerCode
   * @param pageable
   * @return
   */
  @Query("select cb from CustomerBank cb " +
          " where cb.tenantCode = :tenantCode " +
          " and cb.customerCode = :customerCode " +
          " and cb.tstatus = :tstatus " +
          " order by cb.createTime desc ")
  Page<CustomerBank> findByTenantCodeAndCustomerCodeAndTstatus(@Param("tenantCode") String tenantCode, @Param("customerCode") String customerCode, @Param("tstatus") Integer tstatus, Pageable pageable);

  /**
   * 查找一个租户下面一个银行卡号的唯一性
   *
   * @param tenantCode
   * @param cardNumber
   * @param tstatus
   * @return
   */
  @Query("select cb from CustomerBank cb " +
          "where cb.tenantCode = :tenantCode " +
          "and cb.cardNumber = :cardNumber " +
          "and cb.tstatus = :tstatus")
  CustomerBank findByTenantCodeAndCardNumberAndTstatus(@Param("tenantCode") String tenantCode,@Param("cardNumber") String cardNumber, @Param("tstatus") Integer tstatus);
}
