package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.CustomerCreditBill;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * CustomerCreditBill业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_CustomerCreditBillRepository")
public interface CustomerCreditBillRepository
    extends
    JpaRepository<CustomerCreditBill, String>
    , JpaSpecificationExecutor<CustomerCreditBill> {


  /**
   * 根据客户编码查询客户的信用流水记录
   * @param customerCode
   * @param pageable
   * @return
   */
  @Query("select ccb from CustomerCreditBill ccb " +
      " inner join ccb.customerCredit cc " +
      " where cc.tenantCode = :tenantCode " +
      " and cc.customerCode = :customerCode " +
      " order by ccb.createTime desc ")
  Page<CustomerCreditBill> findByTenantCodeAndCustomerCode(@Param("tenantCode") String tenantCode, @Param("customerCode") String customerCode, Pageable pageable);

  /**
   * 根据租户编码和业务编码统计
   * @param businessNo
   * @return
   */
  long countByTenantCodeAndBusinessNo(@Param("tenantCode") String tenantCode, @Param("businessNo") String businessNo);
}