package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.CustomerCreditRecord;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * CustomerCreditRecord业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_CustomerCreditRecordRepository")
public interface CustomerCreditRecordRepository
    extends
    JpaRepository<CustomerCreditRecord, String>
    , JpaSpecificationExecutor<CustomerCreditRecord> {


  /**
   * 根据客户编码分页查询
   *
   * @param tenantCode
   * @param customerCode
   * @param pageable
   * @return
   */
  @Query("select ccr from CustomerCreditRecord ccr " +
      " inner join ccr.customerCredit cc " +
      " where cc.tenantCode = :tenantCode " +
      " and cc.customerCode = :customerCode " +
      " order by ccr.createTime desc")
  Page<CustomerCreditRecord> findByTenantCodeAndCustomerCode(@Param("tenantCode") String tenantCode, @Param("customerCode") String customerCode, Pageable pageable);
}