package com.bizunited.empower.business.payment.repository;


import com.bizunited.empower.business.payment.entity.CustomerCredit;
import com.bizunited.empower.business.payment.repository.internal.CustomerCreditRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * CustomerCredit业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_CustomerCreditRepository")
public interface CustomerCreditRepository
    extends
    JpaRepository<CustomerCredit, String>
    , JpaSpecificationExecutor<CustomerCredit>
    , CustomerCreditRepositoryCustom {

  /**
   * 根据客户编码查询客户的信用信息
   * @param customerCode
   * @return
   */
  @Query("select cc from CustomerCredit cc " +
         "left join fetch cc.customerCreditBills " +
         "where cc.tenantCode = :tenantCode and cc.customerCode = :customerCode")
  CustomerCredit findByTenantCodeAndCustomerCode(@Param("tenantCode") String tenantCode, @Param("customerCode") String customerCode);

}