package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.CustomerWalletBill;
import com.bizunited.empower.business.payment.repository.internal.CustomerWalletBillRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Date;

/**
 * CustomerWalletBill业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_CustomerWalletBillRepository")
public interface CustomerWalletBillRepository
    extends
    JpaRepository<CustomerWalletBill, String>
    , JpaSpecificationExecutor<CustomerWalletBill>
    , CustomerWalletBillRepositoryCustom {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct customerWalletBill from CustomerWalletBill customerWalletBill "
      + " left join fetch customerWalletBill.wallet customerWalletBill_wallet "
      + " where customerWalletBill.id=:id ")
  CustomerWalletBill findDetailsById(@Param("id") String id);

  /**
   * 根据类型、时间段统计金额
   * @param type
   * @param start
   * @param end
   * @return
   */
  @Query("select sum(cwb.amount) from CustomerWalletBill cwb " +
      " inner join cwb.wallet cw " +
      " where cw.tenantCode = :tenantCode " +
      " and cwb.type = :type " +
      " and cwb.createTime >= :start and cwb.createTime <= :end ")
  BigDecimal sumAmountByTenantCodeAndTypeAndCreateTimeBetween(@Param("tenantCode") String tenantCode, @Param("type") Integer type,
                                                              @Param("start") Date start, @Param("end") Date end);
}