package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.CustomerWallet;
import com.bizunited.empower.business.payment.repository.internal.CustomerWalletRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;

/**
 * CustomerWallet业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_CustomerWalletRepository")
public interface CustomerWalletRepository
    extends
    JpaRepository<CustomerWallet, String>
    , JpaSpecificationExecutor<CustomerWallet>
    , CustomerWalletRepositoryCustom {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct customerWallet from CustomerWallet customerWallet "
      + " where customerWallet.id=:id ")
  CustomerWallet findDetailsById(@Param("id") String id);

  /**
   * 根据客户编码查询
   * @param tenantCode
   * @param customerCode
   * @return
   */
  CustomerWallet findByTenantCodeAndCustomerCode(@Param("tenantCode") String tenantCode, @Param("customerCode") String customerCode);

  /**
   * 统计经销商统计余额
   * @param tenantCode
   * @return
   */
  @Query("select sum(cw.balance) from CustomerWallet cw where cw.tenantCode = :tenantCode")
  BigDecimal sumBalanceByTenantCode(@Param("tenantCode") String tenantCode);
}