package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.DefrayAttachment;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * ReceiptFile业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_DefrayAttachmentRepository")
public interface DefrayAttachmentRepository
    extends
      JpaRepository<DefrayAttachment, String>
      ,JpaSpecificationExecutor<DefrayAttachment>
  {
  /**
   * 按照收款单编号进行详情查询（包括关联信息）
   * @param id 收款单编号
   * */
  @Query("select distinct defrayAttachment from DefrayAttachment defrayAttachment "
      + " left join fetch defrayAttachment.defrayInfo defrayAttachment_defrayInfo "
       + " where defrayAttachment_defrayInfo.id = :id")
  Set<DefrayAttachment> findDetailsByDefrayInfo(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct defrayAttachment from DefrayAttachment defrayAttachment "
      + " left join fetch defrayAttachment.defrayInfo defrayAttachment_defrayInfo "
      + " where defrayAttachment.id=:id ")
  DefrayAttachment findDetailsById(@Param("id") String id);

}