package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.ElectronicAccountBank;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * ElectronicAccountBank业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ElectronicAccountBankRepository")
public interface ElectronicAccountBankRepository
    extends
    JpaRepository<ElectronicAccountBank, String>
    , JpaSpecificationExecutor<ElectronicAccountBank> {
  /**
   * 按照电子账户进行详情查询（包括关联信息）
   *
   * @param electronicAccount 电子账户
   */
  @Query("select distinct electronicAccountBank from ElectronicAccountBank electronicAccountBank "
      + " left join fetch electronicAccountBank.electronicAccount electronicAccountBank_electronicAccount "
      + " where electronicAccountBank_electronicAccount.id = :id")
  Set<ElectronicAccountBank> findDetailsByElectronicAccount(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct electronicAccountBank from ElectronicAccountBank electronicAccountBank "
      + " left join fetch electronicAccountBank.electronicAccount electronicAccountBank_electronicAccount "
      + " where electronicAccountBank.id=:id ")
  ElectronicAccountBank findDetailsById(@Param("id") String id);

  /**
   * 根据电子账户ID和状态查询
   * @paramZ electronicAccountId
   * @return
   */
  @Query("select eab from ElectronicAccountBank eab " +
      " inner join eab.electronicAccount ea " +
      " where ea.id = :electronicAccountId and eab.state = :state")
  ElectronicAccountBank findByElectronicAccountIdAndState(@Param("electronicAccountId") String electronicAccountId, @Param("state") Integer state);

  /**
   * 根据租户编码和状态查询
   * @param tenantCode
   * @param state
   * @return
   */
  @Query("select eab from ElectronicAccountBank eab " +
      " inner join eab.electronicAccount ea " +
      " where ea.tenantCode = :tenantCode and eab.state = :state")
  ElectronicAccountBank findByTenantCodeAndState(@Param("tenantCode") String tenantCode, @Param("state") Integer state);

  /**
   * 根据电子账户ID和状态统计
   * @paramZ electronicAccountId
   * @return
   */
  @Query("select count(*) from ElectronicAccountBank eab " +
      " inner join eab.electronicAccount ea " +
      " where ea.id = :electronicAccountId and eab.state = :state")
  long countByElectronicAccountIdAndState(@Param("electronicAccountId") String electronicAccountId, @Param("state") Integer state);

  /**
   * 根据电子账户ID和状态统计
   * @paramZ electronicAccountId
   * @return
   */
  @Query("select count(*) from ElectronicAccountBank eab " +
      " inner join eab.electronicAccount ea " +
      " where ea.id = :electronicAccountId and eab.state <> :state")
  long countByElectronicAccountIdAndStateNot(@Param("electronicAccountId") String electronicAccountId, @Param("state") Integer state);


}