package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.ElectronicAccountBillDayStatistics;
import com.bizunited.empower.business.payment.repository.internal.ElectronicAccountBillDayStatisticsRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;

/**
 * 电子账户每日统计数据持久化
 * @Author: Paul Chan
 * @Date: 2021/4/25 上午10:58
 */
@Repository
public interface ElectronicAccountBillDayStatisticsRepository
    extends JpaRepository<ElectronicAccountBillDayStatistics, String>,
    JpaSpecificationExecutor<ElectronicAccountBillDayStatistics>,
    ElectronicAccountBillDayStatisticsRepositoryCustom {

  /**
   * 根据电子账户ID和日期统计
   * @param accountId
   * @param day(yyyy-MM-dd)
   * @return
   */
  @Query("select count(*) from ElectronicAccountBillDayStatistics abds " +
      " inner join abds.electronicAccount a " +
      " where a.id = :accountId and abds.day = :day")
  long countByAccountIdAndDay(@Param("accountId") String accountId, @Param("day") Date day);

}
