package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.ElectronicAccountBill;
import com.bizunited.empower.business.payment.repository.internal.ElectronicAccountBillRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 电子账户流水持久化
 * @Author: Paul Chan
 * @Date: 2021/4/20 上午11:47
 */
public interface ElectronicAccountBillRepository extends
    JpaRepository<ElectronicAccountBill, String>
    , JpaSpecificationExecutor<ElectronicAccountBill>
    , ElectronicAccountBillRepositoryCustom {

  /**
   * 根据租户code和流水号获取流水单
   * @param tenantCode
   * @param billNo
   * @return
   */
  @Query("select eab from ElectronicAccountBill eab " +
      " inner join eab.electronicAccount ea " +
      " where ea.tenantCode = :tenantCode " +
      " and eab.billNo = :billNo")
  ElectronicAccountBill findByTenantCodeAndBillNo(@Param("tenantCode") String tenantCode, @Param("billNo") String billNo);

  /**
   * 根据租户code和业务单号获取流水单
   * @param tenantCode
   * @param businessNo
   * @return
   */
  @Query("select eab from ElectronicAccountBill eab " +
      " inner join eab.electronicAccount ea " +
      " where ea.tenantCode = :tenantCode " +
      " and eab.businessNo = :businessNo")
  List<ElectronicAccountBill> findByTenantCodeAndBusinessNo(@Param("tenantCode") String tenantCode, @Param("businessNo") String businessNo);

  /**
   * 统计真实金额,只统计成功的流水
   * @param type
   * @param startDate
   * @param endDate
   * @return
   */
  @Query("select sum(eab.realAmount) from ElectronicAccountBill eab " +
      " inner join eab.electronicAccount ea " +
      " where ea.tenantCode = :tenantCode " +
      " and eab.state = 1 and eab.type = :type " +
      " and eab.modifyTime >= :startDate " +
      " and eab.modifyTime <= :endDate ")
  BigDecimal sumRealAmountByTenantCodeAndTypeAndModifyTimeBetween(@Param("tenantCode") String tenantCode, @Param("type") Integer type, @Param("startDate") Date startDate, @Param("endDate") Date endDate);

  /**
   * 统计真实金额,只统计成功的流水
   * @param type
   * @param startDate
   * @param endDate
   * @return
   */
  @Query("select sum(eab.realAmount) from ElectronicAccountBill eab " +
      " inner join eab.electronicAccount ea " +
      " where ea.id = :accountId " +
      " and eab.state = 1 and eab.type = :type " +
      " and eab.modifyTime >= :startDate " +
      " and eab.modifyTime <= :endDate ")
  BigDecimal sumRealAmountByTenantCodeAndAccountIdAndTypeAndModifyTimeBetween(@Param("accountId") String accountId, @Param("type") Integer type, @Param("startDate") Date startDate, @Param("endDate") Date endDate);

}
