package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.ElectronicAccountCertificate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * ElectronicAccountCertificate业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_ElectronicAccountCertificateRepository")
public interface ElectronicAccountCertificateRepository
    extends
      JpaRepository<ElectronicAccountCertificate, String>
      ,JpaSpecificationExecutor<ElectronicAccountCertificate>
  {
  /**
   * 按照电子账户进行详情查询（包括关联信息）
   * @param electronicAccount 电子账户
   * */
  @Query("select distinct electronicAccountCertificate from ElectronicAccountCertificate electronicAccountCertificate "
      + " left join fetch electronicAccountCertificate.electronicAccount electronicAccountCertificate_electronicAccount "
       + " where electronicAccountCertificate_electronicAccount.id = :id")
  ElectronicAccountCertificate findDetailsByElectronicAccount(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct electronicAccountCertificate from ElectronicAccountCertificate electronicAccountCertificate "
      + " where electronicAccountCertificate.id=:id ")
  ElectronicAccountCertificate findDetailsById(@Param("id") String id);



}