package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.ElectronicAccountFailureRecord;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 电子账户申请失败记录
 * @Author: Paul Chan
 * @Date: 2021/4/9 上午11:18
 */
@Repository
public interface ElectronicAccountFailureRecordRepository
    extends JpaRepository<ElectronicAccountFailureRecord, String>
    , JpaSpecificationExecutor<ElectronicAccountFailureRecord> {


  /**
   * 根据电子账户ID查询
   * @param electronicAccountId
   * @return
   */
  @Query("select eafr from ElectronicAccountFailureRecord eafr " +
      " inner join eafr.electronicAccount ea " +
      " where ea.id = :electronicAccountId " +
      " order by eafr.createTime asc ")
  List<ElectronicAccountFailureRecord> findByElectronicAccountId(@Param("electronicAccountId") String electronicAccountId);
}
