package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * ElectronicAccount业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_ElectronicAccountRepository")
public interface ElectronicAccountRepository
    extends
    JpaRepository<ElectronicAccount, String>
    , JpaSpecificationExecutor<ElectronicAccount> {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct ea from ElectronicAccount ea " +
      " inner join fetch ea.accountInfo eai " +
      " inner join fetch ea.certificate eac " +
      " left join fetch ea.banks eab " +
      " where ea.id = :id ")
  ElectronicAccount findDetailsById(@Param("id") String id);

  /**
   * 根据经销商编码获取电子账户资料详情
   *
   * @param tenantCode 经销商编码
   */
  @Query("select distinct ea from ElectronicAccount ea " +
      " inner join fetch ea.accountInfo eai " +
      " inner join fetch ea.certificate eac " +
      " left join fetch ea.banks eab " +
      " where ea.tenantCode = :tenantCode ")
  ElectronicAccount findDetailsByTenantCode(@Param("tenantCode") String tenantCode);

  /**
   * 根据厂商编码获取电子账户资料详情
   *
   * @param tenantCode 厂商编码
   */
  @Query("select distinct ea from ElectronicAccount ea where ea.tenantCode = :tenantCode ")
  ElectronicAccount findByTenantCode(@Param("tenantCode") String tenantCode);

  /**
   * 根据
   * @param tenantCode
   * @return
   */
  long countByTenantCode(@Param("tenantCode") String tenantCode);

  /**
   * 根据账户商户编号进行查询
   * @param merchantCode
   * @return
   */
  ElectronicAccount findByMerchantCode(String merchantCode);
}