package com.bizunited.empower.business.payment.repository;
import com.bizunited.empower.business.payment.entity.FundsAccount;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * ReceivableAccount业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_FundsAccountRepository")
public interface FundsAccountRepository
    extends
      JpaRepository<FundsAccount, String>
      ,JpaSpecificationExecutor<FundsAccount>
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct fundsAccount from FundsAccount fundsAccount "
      + " where fundsAccount.id=:id ")
  FundsAccount findDetailsById(@Param("id") String id);



}