package com.bizunited.empower.business.payment.repository;
import com.bizunited.empower.business.payment.entity.ReceiptAttachment;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * ReceiptFile业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_ReceiptAttachmentRepository")
public interface ReceiptAttachmentRepository
    extends
      JpaRepository<ReceiptAttachment, String>
      ,JpaSpecificationExecutor<ReceiptAttachment>
  {
  /**
   * 按照收款单编号进行详情查询（包括关联信息）
   * @param id 收款单编号
   * */
  @Query("select distinct receiptAttachment from ReceiptAttachment receiptAttachment "
      + " left join fetch receiptAttachment.receiptInfo receiptAttachment_receiptInfo "
       + " where receiptAttachment_receiptInfo.id = :id")
  Set<ReceiptAttachment> findDetailsByReceiptInfo(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct receiptAttachment from ReceiptAttachment receiptAttachment "
      + " left join fetch receiptAttachment.receiptInfo receiptAttachment_receiptInfo "
      + " where receiptAttachment.id=:id ")
  ReceiptAttachment findDetailsById(@Param("id") String id);

}