package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.SupplierPaymentInfo;
import com.bizunited.empower.business.payment.repository.internal.SupplierPaymentInfoRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

/**
 * SupplierPaymentInfo业务模型的数据库方法支持
 * @author Keller
 */
public interface SupplierPaymentInfoRepository extends
        JpaRepository<SupplierPaymentInfo, String>
        , JpaSpecificationExecutor<SupplierPaymentInfo>
        , SupplierPaymentInfoRepositoryCustom {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct supplierPaymentInfo from SupplierPaymentInfo supplierPaymentInfo "
          + " where supplierPaymentInfo.id=:id ")
  SupplierPaymentInfo findDetailsById(@Param("id") String id);

  /**
   * 按照应收账款流水编号进行查询
   *
   * @param paymentCode 应收账款流水编号
   */
  @Query(" from SupplierPaymentInfo f "
          + " where f.paymentCode = :paymentCode and f.tenantCode = :tenantCode and f.tstatus=1")
  SupplierPaymentInfo findByPaymentCodeAndTenantCode(@Param("paymentCode") String paymentCode, @Param("tenantCode") String tenantCode);

  /**
   * 按照订单编号进行查询
   *
   * @param associatedCode 订单编号
   */
  @Query(" from SupplierPaymentInfo f "
          + " where f.associatedCode = :associatedCode and f.tenantCode = :tenantCode and f.tstatus=1")
  SupplierPaymentInfo findByAssociatedCodeAndTenantCode(@Param("associatedCode") String associatedCode, @Param("tenantCode") String tenantCode);

}
