package com.bizunited.empower.business.payment.repository;

import com.bizunited.empower.business.payment.entity.SupplierReceivableInfo;
import com.bizunited.empower.business.payment.repository.internal.SupplierReceivableInfoRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Set;

/**
 * SupplierReceivableInfo业务模型的数据库方法支持
 *
 * @author Keller
 */
public interface SupplierReceivableInfoRepository extends
        JpaRepository<SupplierReceivableInfo, String>
        , JpaSpecificationExecutor<SupplierReceivableInfo>
        , SupplierReceivableInfoRepositoryCustom {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct supplierReceivableInfo from SupplierReceivableInfo supplierReceivableInfo "
          + " where supplierReceivableInfo.id=:id ")
  SupplierReceivableInfo findDetailsById(@Param("id") String id);

  /**
   * 按照应收账款流水编号进行查询
   * @param receivableCode 应收账款流水编号
   * */
  @Query(" from SupplierReceivableInfo f "
          + " where f.receivableCode = :receivableCode and f.tenantCode = :tenantCode and f.tstatus=1")
  SupplierReceivableInfo findByReceivableCodeAndTenantCode(@Param("receivableCode") String receivableCode, @Param("tenantCode") String tenantCode);

  /**
   * 按照关联单编号进行查询
   * @param associatedCode 订单编号
   * */
  @Query(" from SupplierReceivableInfo f "
          + " where f.associatedCode = :associatedCode and f.tenantCode = :tenantCode and f.tstatus=1")
  SupplierReceivableInfo findByAssociatedCodeAndTenantCode(@Param("associatedCode") String associatedCode,@Param("tenantCode") String tenantCode);

  /**
   * 按照关联单编号集合进行查询
   * @param associatedCodes 订单编号集合
   * */
  @Query("select distinct f from SupplierReceivableInfo f "
          + " where f.associatedCode in (:associatedCodes) and f.tenantCode = :tenantCode and f.tstatus=1 order by f.createTime desc")
  List<SupplierReceivableInfo> findByAssociatedCodesAndTenantCode(@Param("associatedCodes") Set<String> associatedCodes, @Param("tenantCode") String tenantCode);

}
