package com.bizunited.empower.business.payment.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CustomerCredit模型的数据层自定义接口，可以由程序员根据实际情况完善
 *
 * @author Keller
 */
public class CustomerCreditRepositoryImpl  implements CustomerCreditRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  /**
   * 租户编码key
   */
  private final String TENANT_CODE = "tenantCode";
  /**
   * 用户信用状态
   */
  private final String TSTATUS = "tstatus";
  /**
   * 用户级别
   */
  private final String LEVEL_CODE = "levelCode";
  /**
   * 模糊查询
   */
  private final String BLURRY = "blurry";

  @SuppressWarnings("unchecked")
  @Override
  public Page<Object[]> queryPage(Pageable pageable, InvokeParams conditions) {
    StringBuilder sql = new StringBuilder("select c.customer_code,cu.customer_name,cl.level_name,cc.name,sa.sales_area_name,c.tstatus,c.total_amount,c.used_amount,c.balance,c.create_time ");
    StringBuilder countSql = new StringBuilder("select count(c.id) ");
    StringBuilder condition = new StringBuilder();
    StringBuilder joinSql = new StringBuilder();
    joinSql.append(" from customer_credit c ");
    joinSql.append(" left join customer as cu on c.customer_code=cu.customer_code");
    joinSql.append(" left join customer_level cl on cu.customer_level=cl.id ");
    joinSql.append(" left join customer_category cc on cc.id=cu.customer_category ");
    joinSql.append(" left join sales_area sa on sa.id=cu.sales_area_id ");

    Map<String, Object> parameters = new HashMap<>();
    Map<String, Object> params = conditions.getInvokeParams();
    String tenantCode = (String) params.get(TENANT_CODE);
    Validate.notBlank(tenantCode, "租户编号为空");
    String tstatus = (String) params.get(TSTATUS);
    String levelCode = (String) params.get(LEVEL_CODE);
    String blurry = (String) params.get(BLURRY);

    condition.append("where 1=1 ");
    condition.append(" and c.tenant_code=:tenantCode and cu.tenant_code=:tenantCode ");
    parameters.put("tenantCode", tenantCode);

    if (conditions != null) {
      if (StringUtils.isNotBlank(tstatus)) {
        condition.append(" and c.tstatus=:tstatus");
        parameters.put("tstatus", Integer.parseInt(tstatus));
      }
      if (StringUtils.isNotBlank(levelCode)) {
        condition.append(" and cl.level_code=:levelCode");
        parameters.put("levelCode", levelCode);
      }
      if (StringUtils.isNotBlank(blurry)) {
        condition.append(" and (c.customer_code like concat('%',:blurry,'%') or cu.customer_name like concat('%',:blurry,'%'))");
        parameters.put("blurry", blurry);
      }
    }
    sql.append(joinSql).append(condition).append(" order by c.create_time desc");
    countSql.append(joinSql).append(condition);

    Query query = entityManager.createNativeQuery(sql.toString());
    Query countQuery = entityManager.createNativeQuery(countSql.toString());
    parameters.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });

    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<Object[]> resutls = query.getResultList();
    // 查询总数量信息
    Number count = (Number) countQuery.getResultList().get(0);
    return new PageImpl<>(resutls, pageable, count == null ? 0L : count.longValue());
  }
}
