package com.bizunited.empower.business.payment.repository.internal;

import com.bizunited.empower.business.payment.entity.CustomerWalletBill;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Map;

/**
 * 客户电子钱包流水持久化自定义实现接口定义
 * @Author: Paul Chan
 * @Date: 2021/4/13 下午2:44
 */
public interface CustomerWalletBillRepositoryCustom {

  /**
   * 根据客户编码和条件查询客户的交易记录
   * @param customerCode
   * @param pageable
   * @param conditions
   * @return
   */
  Page<CustomerWalletBill> findByCustomerCodeAndConditions(String customerCode, Pageable pageable, Map<String, Object> conditions);
}
