package com.bizunited.empower.business.payment.repository.internal;

import com.bizunited.empower.business.payment.entity.CustomerWalletBill;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/**
 * 客户电子钱包流水持久化自定义实现
 * @Author: Paul Chan
 * @Date: 2021/4/13 下午2:45
 */
public class CustomerWalletBillRepositoryImpl implements CustomerWalletBillRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  public Page<CustomerWalletBill> findByCustomerCodeAndConditions(String customerCode, Pageable pageable, Map<String, Object> conditions) {
    StringBuilder hql = new StringBuilder("select distinct cwb from CustomerWalletBill cwb inner join cwb.wallet cw where cw.customerCode = :customerCode ");
    StringBuilder countHql = new StringBuilder("select count(distinct cwb.id) from CustomerWalletBill cwb inner join cwb.wallet cw where cw.customerCode = :customerCode ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    parameter.put("customerCode", customerCode);
    if(conditions != null) {
      Integer type = (Integer) conditions.get("type");
      String tenantCode = (String) conditions.get("tenantCode");
      if(StringUtils.isNotBlank(tenantCode)) {
        condition.append(" and cw.tenantCode = :tenantCode ");
        parameter.put("tenantCode", tenantCode);
      }
      if(type != null) {
        condition.append(" and cwb.type = :type ");
        parameter.put("type", type);
      }
    }
    hql.append(condition).append(" order by cwb.createTime desc ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }

}
