package com.bizunited.empower.business.payment.repository.internal;

import com.bizunited.empower.business.payment.entity.CustomerWallet;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.List;
import java.util.Map;

/**
 * 客户电子钱包持久化自定义实现
 * @Author: Paul Chan
 * @Date: 2021/4/13 下午3:41
 */
public class CustomerWalletRepositoryImpl implements CustomerWalletRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @SuppressWarnings("unchecked")
  @Override
  public Page<CustomerWallet> findByConditions(Map<String, Object> conditions, Pageable pageable) {
    StringBuilder hql = new StringBuilder("select cw from CustomerWallet cw where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from CustomerWallet cw where 1=1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = Maps.newHashMap();
    if(conditions != null) {
      String tenantCode = (String) conditions.get("tenantCode");
      if(StringUtils.isNotBlank(tenantCode)) {
        condition.append(" and cw.tenantCode = :tenantCode ");
        parameter.put("tenantCode", tenantCode);
      }
      List<String> customerCodes = (List<String>) conditions.get("customerCodes");
      if(!CollectionUtils.isEmpty(customerCodes)) {
        condition.append(" and cw.customerCode in :customerCodes ");
        parameter.put("customerCodes", customerCodes);
      }
    }
    hql.append(condition).append(" order by cw.createTime desc ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }
}
