package com.bizunited.empower.business.payment.repository.internal;

import com.bizunited.empower.business.payment.entity.ElectronicAccountBillDayStatistics;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.Date;
import java.util.Map;

/**
 * 电子账户每日统计数据持久化自定义实现
 * @Author: Paul Chan
 * @Date: 2021/4/25 下午3:00
 */
public class ElectronicAccountBillDayStatisticsRepositoryImpl implements ElectronicAccountBillDayStatisticsRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  public Page<ElectronicAccountBillDayStatistics> findByConditions(Map<String, Object> conditions, Pageable pageable) {
    StringBuilder hql = new StringBuilder("select abds from ElectronicAccountBillDayStatistics abds inner join abds.electronicAccount a where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from ElectronicAccountBillDayStatistics abds inner join abds.electronicAccount a where 1=1 ");
    Map<String, Object> parameter = Maps.newHashMap();
    StringBuilder condition = new StringBuilder();
    if(conditions != null) {
      String tenantCode = (String) conditions.get("tenantCode");
      String accountId = (String) conditions.get("accountId");
      Date startDate = (Date) conditions.get("startDate");
      Date endDate = (Date) conditions.get("endDate");
      if(StringUtils.isNotBlank(tenantCode)) {
        condition.append(" and a.tenantCode = :tenantCode ");
        parameter.put("tenantCode", tenantCode);
      }
      if(StringUtils.isNotBlank(accountId)) {
        condition.append(" and a.id = :accountId ");
        parameter.put("accountId", accountId);
      }
      if(startDate != null) {
        condition.append(" and abds.day >= :startDate ");
        parameter.put("startDate", startDate);
      }
      if(startDate != null) {
        condition.append(" and abds.day <= :endDate ");
        parameter.put("endDate", endDate);
      }
    }
    hql.append(condition).append(" order by abds.day desc ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }
}
