package com.bizunited.empower.business.payment.repository.internal;

import com.bizunited.empower.business.common.util.DateUtils;
import com.bizunited.empower.business.payment.entity.ElectronicAccountBill;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.Date;
import java.util.Map;

/**
 * 电子账户流水信息持久化自定义实现接口定义
 * @Author: Paul Chan
 * @Date: 2021/4/20 下午5:17
 */
public class ElectronicAccountBillRepositoryImpl implements ElectronicAccountBillRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  public Page<ElectronicAccountBill> findByConditions(Map<String, Object> conditions, Pageable pageable) {
    StringBuilder hql = new StringBuilder("select eab from ElectronicAccountBill eab inner join fetch eab.electronicAccount ea where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from ElectronicAccountBill eab inner join eab.electronicAccount ea where 1=1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = Maps.newHashMap();
    if(conditions != null) {
      String tenantCode = (String) conditions.get("tenantCode");
      Integer type = (Integer) conditions.get("type");
      Integer state = (Integer) conditions.get("state");
      Integer businessType = (Integer) conditions.get("businessType");
      String billNo = (String) conditions.get("billNo");
      Date startDate = (Date) conditions.get("startDate");
      Date endDate = (Date) conditions.get("endDate");
      if(StringUtils.isNotBlank(tenantCode)) {
        condition.append(" and ea.tenantCode = :tenantCode ");
        parameters.put("tenantCode", tenantCode);
      }
      if(type != null) {
        condition.append(" and eab.type = :type ");
        parameters.put("type", type);
      }
      if(state != null) {
        condition.append(" and eab.state = :state ");
        parameters.put("type", state);
      }
      if(businessType != null) {
        condition.append(" and eab.businessType = :businessType ");
        parameters.put("businessType", businessType);
      }
      if(StringUtils.isNotBlank(billNo)) {
        condition.append(" and eab.billNo like concat(:billNo,'%') ");
        parameters.put("billNo", billNo);
      }
      if(startDate != null) {
        startDate = DateUtils.getStartDate(startDate);
        condition.append(" and eab.createTime >= :startDate ");
        parameters.put("startDate", startDate);
      }
      if(endDate != null) {
        endDate = DateUtils.getEndDate(endDate);
        condition.append(" and eab.createTime < :endDate ");
        parameters.put("endDate", endDate);
      }
    }
    hql.append(condition).append(" order by eab.createTime desc ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }
}
