package com.bizunited.empower.business.payment.repository.internal;

import com.bizunited.empower.business.payment.vo.SupplierPaymentInfoVo;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * SupplierPaymentInfo模型的数据层自定义接口实现，可以由程序员根据实际情况完善
 *
 * @author Keller
 */
public class SupplierPaymentInfoRepositoryImpl implements SupplierPaymentInfoRepositoryCustom, PageRepositoryImpl {
  /**
   * 租户编码key
   */
  private final String TENANT_CODE = "tenantCode";
  /**
   * 供应商编号
   */
  private final String SUPPLIER_CODE = "supplierCode";
  /**
   * 应付账款状态：未付款1、已付款2
   */
  private final String PAYMENT_STATUS = "paymentStatus";
  /**
   * 单据开始时间
   */
  private final String START_TIME = "startTime";
  /**
   * 单据结束时间
   */
  private final String END_TIME = "endTime";
  /**
   * 应收账款编号
   */
  private final String PAYMENT_CODE = "paymentCode";
  /**
   * 创建人账号（业务员账号）
   */
  private final String CREATE_ACCOUNT = "account";

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  public Page<SupplierPaymentInfoVo> queryPageForAssociated(Pageable pageable, InvokeParams conditions) {
    StringBuilder hql = new StringBuilder("from SupplierPaymentInfo c where 1=1 and c.tstatus=1");
    StringBuilder countHql = new StringBuilder("select count(*) FROM SupplierPaymentInfo c where 1=1 and c.tstatus=1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();

    Map<String, Object> params = conditions.getInvokeParams();
    String tenantCode = (String) params.get(TENANT_CODE);
    String paymentStatus = (String) params.get(PAYMENT_STATUS);
    String startTime = (String) params.get(START_TIME);
    String endTime = (String) params.get(END_TIME);
    String paymentCode = (String) params.get(PAYMENT_CODE);
    String account = (String) params.get(CREATE_ACCOUNT);
    String supplierCode = (String) params.get(SUPPLIER_CODE);

    Validate.notBlank(tenantCode, "租户编号为空");

    condition.append(" and c.tenantCode=:tenantCode");
    parameters.put("tenantCode", tenantCode);

    if (conditions != null) {
      if (StringUtils.isNotBlank(account)) {
        condition.append(" and c.createAccount=:account");
        parameters.put("account", account);
      }
      if (StringUtils.isNotBlank(supplierCode)) {
        condition.append(" and c.supplierCode=:supplierCode");
        parameters.put("supplierCode", supplierCode);
      }
      if (StringUtils.isNotBlank(paymentStatus)) {
        condition.append(" and c.paymentStatus=:paymentStatus");
        parameters.put("paymentStatus", Integer.parseInt(paymentStatus));
      }
      if (StringUtils.isNotBlank(startTime)) {
        condition.append(" and c.createTime >=:startTime");
        parameters.put("startTime", parseDate(startTime));
      }
      if (StringUtils.isNotBlank(endTime)) {
        condition.append(" and c.createTime <=:endTime");
        parameters.put("endTime", parseDate(endTime));
      }
      if (StringUtils.isNotBlank(paymentCode)) {
        condition.append(" and c.paymentCode like concat(:paymentCode,'%')");
        parameters.put("paymentCode", paymentCode);
      }
    }
    hql.append(condition).append(" order by c.createTime desc");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, SupplierPaymentInfoVo.class);
  }

  /**
   * 日期格式转换
   *
   * @param time
   * @return
   */
  private Date parseDate(String time) {
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Date date = null;
    try {
      date = df.parse(time);
    } catch (ParseException e) {
      throw new IllegalArgumentException("日期格式转换错误", e);
    }
    return date;
  }
}
