package com.bizunited.empower.business.payment.repository.internal;

import com.bizunited.empower.business.payment.vo.SupplierReceivableInfoVo;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * SupplierReceivableInfo模型的数据层自定义接口实现，可以由程序员根据实际情况完善
 *
 * @author saturn
 */
public class SupplierReceivableInfoRepositoryImpl implements SupplierReceivableInfoRepositoryCustom, PageRepositoryImpl {
  /**
   * 租户编码key
   */
  private final String TENANT_CODE = "tenantCode";
  /**
   * 应收账款状态
   */
  private final String RECEIVABLE_STATUS = "receivableStatus";
  /**
   * 单据开始时间
   */
  private final String START_TIME = "startTime";
  /**
   * 单据结束时间
   */
  private final String END_TIME = "endTime";
  /**
   * 应收账款编号
   */
  private final String RECEIVABLE_CODE = "receivableCode";

  /** 客户编号 */
  private final String SUPPLIER_CODE = "supplierCode";
  /** 客户名称 */
  private final String SUPPLIER_NAME = "supplierName";
  /** 最小订单金额 */
  private final String MIN_ORDER_AMOUNT = "minOrderAmount";
  /** 最大订单金额 */
  private final String MAX_ORDER_AMOUNT = "maxOrderAmount";
  /** 创建人（业务员） */
  private final String CREATE_ACCOUNT = "account";
  /** 关联的订单编号 */
  private final String ASSOCIATE_CODE = "associatedCode";

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  public Page<SupplierReceivableInfoVo> queryPageForAssociated(Pageable pageable, InvokeParams conditions) {
    StringBuilder hql = new StringBuilder("from SupplierReceivableInfo c where 1=1 and c.tstatus=1");
    StringBuilder countHql = new StringBuilder("select count(*) FROM SupplierReceivableInfo c where 1=1 and c.tstatus=1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();

    Map<String, Object> params = conditions.getInvokeParams();
    String tenantCode = (String) params.get(TENANT_CODE);
    String receivableStatus = (String) params.get(RECEIVABLE_STATUS);
    String startTime = (String) params.get(START_TIME);
    String endTime = (String) params.get(END_TIME);
    String receivableCode = (String) params.get(RECEIVABLE_CODE);

    String supplierCode = (String) params.get(SUPPLIER_CODE);
    String supplierName = (String) params.get(SUPPLIER_NAME);
    String minOrderAmount = (String) params.get(MIN_ORDER_AMOUNT);
    String maxOrderAmount = (String) params.get(MAX_ORDER_AMOUNT);
    String account = (String) params.get(CREATE_ACCOUNT);
    String associatedCode = (String) params.get(ASSOCIATE_CODE);


    Validate.notBlank(tenantCode, "租户编号为空");

    condition.append(" and c.tenantCode=:tenantCode");
    parameters.put("tenantCode", tenantCode);

    if (conditions != null) {
      if (StringUtils.isNotBlank(account)) {
        condition.append(" and c.createAccount=:account");
        parameters.put("account", account);
      }
      if (StringUtils.isNotBlank(associatedCode)) {
        condition.append(" and c.associatedCode =:associatedCode");
        parameters.put("associatedCode", associatedCode);
      }
      if (StringUtils.isNotBlank(minOrderAmount)) {
        condition.append(" and c.receivableAmount>=:minOrderAmount");
        parameters.put("minOrderAmount", new BigDecimal(minOrderAmount));
      }
      if (StringUtils.isNotBlank(maxOrderAmount)) {
        condition.append(" and c.receivableAmount <=:maxOrderAmount");
        parameters.put("maxOrderAmount", new BigDecimal(maxOrderAmount));
      }

      if (StringUtils.isNotBlank(supplierCode)) {
        condition.append(" and c.supplierCode=:supplierCode");
        parameters.put("supplierCode", supplierCode);
      }
      if (StringUtils.isNotBlank(supplierName)) {
        condition.append(" and c.supplierName like concat('%',:customerName,'%')");
        parameters.put("supplierName", supplierName);
      }
      if (StringUtils.isNotBlank(receivableStatus)) {
        condition.append(" and c.receivableStatus=:receivableStatus");
        parameters.put("receivableStatus", Integer.parseInt(receivableStatus));
      }
      if (StringUtils.isNotBlank(startTime)) {
        condition.append(" and c.createTime >=:startTime");
        parameters.put("startTime", parseDate(startTime));
      }
      if (StringUtils.isNotBlank(endTime)) {
        condition.append(" and c.createTime <=:endTime");
        parameters.put("endTime", parseDate(endTime));
      }
      if (StringUtils.isNotBlank(receivableCode)) {
        condition.append(" and c.receivableCode like concat(:receivableCode,'%')");
        parameters.put("receivableCode", receivableCode);
      }
    }
    hql.append(condition).append(" order by c.createTime desc");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, SupplierReceivableInfoVo.class);
  }

  /**
   * 日期格式转换
   *
   * @param time
   * @return
   */
  private Date parseDate(String time) {
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Date date = null;
    try {
      date = df.parse(time);
    } catch (ParseException e) {
      throw new IllegalArgumentException("日期格式转换错误", e);
    }
    return date;
  }
}
