package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.entity.CustomerBank;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * CustomerBank业务模型的服务层接口定义
 *
 * @author Keller
 */
public interface CustomerBankService {

  /**
   * 创建客户银行卡
   *
   * @param customerBank
   */
  CustomerBank create(CustomerBank customerBank);

  /**
   * 删除客户银行卡
   *
   * @param id
   */
  void deleteById(String id);

  /**
   * 根据客户编码查询客户的银行卡信息
   *
   * @param customerCode
   * @param tstatus
   * @param pageable
   */
  Page<CustomerBank> findByCustomerCode(String customerCode, Integer tstatus, Pageable pageable);

  /**
   * 按照客户银行卡号获取信息
   *
   * @param cardNum
   * @return
   */
  CustomerBank findByCardNumAndTenantCode(String cardNum, String tenantCode);
}
