package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.common.enums.CustomerCreditBillType;
import com.bizunited.empower.business.payment.entity.CustomerCredit;
import com.bizunited.empower.business.payment.entity.CustomerCreditBill;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;

/**
 * CustomerCreditBill业务模型的服务层接口定义
 * @author saturn
 */
public interface CustomerCreditBillService {

  /**
   * 创建客户信用流水单
   * @param customerCredit
   * @param businessNo
   * @param amount
   * @param balance
   * @param payment
   * @param remark
   * @return
   */
  CustomerCreditBill create(CustomerCredit customerCredit, String businessNo, BigDecimal amount, BigDecimal balance, CustomerCreditBillType payment, String remark);

  /**
   * 根据客户编码查询客户的信用流水记录
   * @param customerCode
   * @param pageable
   * @return
   */
  Page<CustomerCreditBill> findByCustomerCode(String customerCode, Pageable pageable);
}