package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.entity.CustomerCredit;
import com.bizunited.empower.business.payment.entity.CustomerCreditRecord;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;

/**
 * CustomerCreditRecord业务模型的服务层接口定义
 *
 * @author saturn
 */
public interface CustomerCreditRecordService {

  /**
   * 创建客户信用额度变更记录
   * @param customerCredit
   * @param amount
   * @param beforeAmount
   * @param afterAmount
   * @param remark
   * @return
   */
  CustomerCreditRecord create(CustomerCredit customerCredit, BigDecimal amount, BigDecimal beforeAmount, BigDecimal afterAmount, String remark);

  /**
   * 根据客户编码分页查询
   * @param pageable
   * @param customerCode
   * @return
   */
  Page<CustomerCreditRecord> findByCustomerCode(Pageable pageable, String customerCode);
}