package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.common.enums.WalletBillBusinessType;
import com.bizunited.empower.business.payment.entity.CustomerWallet;
import com.bizunited.empower.business.payment.entity.CustomerWalletBill;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

/**
 * CustomerWalletBill业务模型的服务层接口定义
 *
 * @author saturn
 */
public interface CustomerWalletBillService {

  /**
   * 创建电子钱包流水信息
   * @param wallet 钱包信息
   * @param amount 金额
   * @param businessType 业务类型，1：提现、2：充值、3：转账结余、4：退货退款、4：应付单
   * @param businessNo 业务编号
   * @param remark 备注
   */
  CustomerWalletBill create(CustomerWallet wallet, BigDecimal amount, WalletBillBusinessType businessType, String businessNo, String remark);

  /**
   * 根据客户编码和条件查询客户的交易记录
   * @param customerCode
   * @param pageable
   * @param conditions
   * @return
   */
  Page<CustomerWalletBill> findByCustomerCodeAndConditions(String customerCode, Pageable pageable, Map<String, Object> conditions);

  /**
   * 根据类型、时间段统计
   * @param type
   * @param start
   * @param end
   * @return
   */
  BigDecimal sumAmountByTypeAndTimeBetween(Integer type, Date start, Date end);
}