package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.entity.CustomerWallet;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.Map;

/**
 * CustomerWallet业务模型的服务层接口定义
 * @author saturn
 */
public interface CustomerWalletService {

  /**
   * 初始化电子钱包
   * @param customerCode
   * @return
   */
  CustomerWallet init(String customerCode);

  /**
   * 该接口功能负责生成基于“客户余额”的应收账款以及相应的收款凭证，在此基础上付款中心中该经销商的余额将被立即扣减。
   * @param customerCode
   * @param amount
   * @param businessType
   * @param businessNo
   * @param remark
   * @return
   */
  CustomerWallet receipt(String customerCode, BigDecimal amount, Integer businessType, String businessNo, String remark);

  /**
   * 该接口功能负责生成基于“客户余额”的应收账款以及相应的收款凭证，在此基础上付款中心中该经销商的余额将被立即扣减。
   * @param customerCode
   * @param amount
   * @param businessType
   * @param businessNo
   * @param validCode
   * @param remark
   * @return
   */
  CustomerWallet receipt(String customerCode, BigDecimal amount, Integer businessType, String businessNo, String validCode, String remark);

  /**
   * 恢复金额
   * @param customerCode
   * @param amount
   * @param businessType
   * @param businessNo
   * @param remark
   * @return
   */
  CustomerWallet recover(String customerCode, BigDecimal amount, Integer businessType, String businessNo, String remark);

  /**
   * 提现
   * @param customerCode
   * @param amount 提现金额，如果传入null，则表示全部提现
   * @param remark
   * @return
   */
  CustomerWallet withdraw(String customerCode, BigDecimal amount, String remark);

  /**
   * 该接口功能负责验证在扣减余额前对余额支付的额度校验，如果额度不足则返回false，能够正常扣减信用则返回true
   *
   * @param customerCode 指定的经销商客户业务编号
   * @param amount       需要减少的金额
   * @return
   */
  boolean validReceipt(String customerCode, BigDecimal amount);

  /**
   * 按照CustomerWallet的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  CustomerWallet findById(String id);

  /**
   * 通过客户编码查询
   * @param customerCode
   * @return
   */
  CustomerWallet findByCustomerCode(String customerCode);

  /**
   * 多条件分页查询
   * @param conditions
   * @param pageable
   * @return
   */
  Page<CustomerWallet> findByConditions(Map<String, Object> conditions, Pageable pageable);

  /**
   * 统计总的余额
   * @return
   */
  BigDecimal sumBalance();
}