package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.bizunited.empower.business.payment.entity.ElectronicAccountBank;

import java.util.Set;

/**
 * ElectronicAccountBank业务模型的服务层接口定义
 *
 * @author saturn
 */
public interface ElectronicAccountBankService {

  /**
   * 新增银行卡
   *
   * @param bank
   * @return
   */
  ElectronicAccountBank create(ElectronicAccountBank bank);

  /**
   * 修改银行卡
   *
   * @param bank
   * @return
   */
  ElectronicAccountBank update(ElectronicAccountBank bank);

  /**
   * 保存银行信息
   */
  Set<ElectronicAccountBank> save(ElectronicAccount electronicAccount, Set<ElectronicAccountBank> banks);

  /**
   * 发送短信验证码
   *
   * @param id
   */
  void sendValidCodeById(String id);

  /**
   * 绑定银行卡
   *
   * @param id
   * @param validCode
   */
  void bindById(String id, String validCode);

  /**
   * 解绑银行卡
   *
   * @param id
   * @param validCode
   */
  void unbindById(String id, String validCode);

  /**
   * 绑定电子账户银行卡
   *
   * @param electronicAccountId
   */
  void bindByElectronicAccountId(String electronicAccountId);

  /**
   * 根据账户ID绑定银行卡
   *
   * @param electronicAccountId
   * @param validCode
   */
  void bindByElectronicAccountId(String electronicAccountId, String validCode);

  /**
   * 根据电子账户ID查询可用状态的银行卡
   * 需求是，一个电子账户只能有一个正常的银行卡
   *
   * @param electronicAccountId
   * @return
   */
  ElectronicAccountBank findEnableByElectronicAccountId(String electronicAccountId);

  /**
   * 查询当前可用的银行卡信息
   *
   * @return
   */
  ElectronicAccountBank findEnableByTenant();
}