package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.entity.ElectronicAccountBillDayStatistics;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
 * 电子账户每日统计数据服务
 * @Author: Paul Chan
 * @Date: 2021/4/25 下午2:16
 */
public interface ElectronicAccountBillDayStatisticsService {

  /**
   * 多条件分页查询
   * @param conditions
   * @param pageable
   * @return
   */
  Page<ElectronicAccountBillDayStatistics> findByConditions(Map<String, Object> conditions, Pageable pageable);

  /**
   * 统计昨天电子账户流水信息
   */
  void sumYesterdayAmount();

  /**
   * 统计指定厂商下电子账户信息
   */
  void sumYesterdayAmountByApp();

  /**
   * 获取最近指定天数的数据
   * @param days
   * @return
   */
  List<ElectronicAccountBillDayStatistics> findByDays(Integer days);

}
