package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.dto.CpcnResultDto;
import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;

/**
 * 电子账户dto服务
 *
 * @Author: Paul Chan
 * @Date: 2021/4/14 下午4:20
 */
public interface ElectronicAccountDtoService {

  /**
   * 创建电子账户
   *
   * @param electronicAccountDto
   */
  void create(ElectronicAccountDto electronicAccountDto);

  /**
   * 更新电子账户
   *
   * @param electronicAccountDto
   */
  void update(ElectronicAccountDto electronicAccountDto);

  /**
   * 更新安全手机号码
   * @param electronicAccountDto
   */
  void updateSecurePhone(ElectronicAccountDto electronicAccountDto);

  /**
   * 更新银行卡信息
   * @param electronicAccountDto
   * @return
   */
  CpcnResultDto updateForTiedCard(ElectronicAccountDto electronicAccountDto);

  /**
   * 发起绑卡请求
   * @param electronicAccountDto
   */
  CpcnResultDto handleTiedCard(ElectronicAccountDto electronicAccountDto);

  /**
   * 处理MQ同步的电子账户信息
   *
   * @param electronicAccountDto
   */
  void handleMq(ElectronicAccountDto electronicAccountDto);

  /**
   * 发送签约验证码
   *
   * @param electronicAccountDto
   */
  void sendSignValidCode(ElectronicAccountDto electronicAccountDto, Boolean isUpdate);

  /**
   * 绑定银行卡
   *
   * @param electronicAccountDto
   * @param validCode            验证信息
   */
  CpcnResultDto bindBank(ElectronicAccountDto electronicAccountDto, String validCode);

  /**
   * 解绑银行卡
   * @param electronicAccountDto
   * @return
   */
  CpcnResultDto unbindBank(ElectronicAccountDto electronicAccountDto);

  /**
   * 获取签约地址
   *
   * @param electronicAccountDto
   * @param validCode
   * @return
   */
  String findSignUrl(ElectronicAccountDto electronicAccountDto, String validCode);
}
