package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.entity.ElectronicAccountFailureRecord;

import java.util.List;

/**
 * 电子账户申请失败服务接口定义
 * @Author: Paul Chan
 * @Date: 2021/4/9 上午11:20
 */
public interface ElectronicAccountFailureRecordService {

  /**
   * 创建电子账户申请失败信息
   * @param record
   * @return
   */
  ElectronicAccountFailureRecord create(ElectronicAccountFailureRecord record);

  /**
   * 根据电子账户ID查询
   * @param electronicAccountId
   * @return
   */
  List<ElectronicAccountFailureRecord> findByElectronicAccountId(String electronicAccountId);

  /**
   * 创建失败原因
   * @param accountId
   * @param failureReason
   * @return
   */
  ElectronicAccountFailureRecord create(String accountId, String failureReason);
}
