package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.bizunited.empower.business.payment.vo.ExtractCashVo;

import java.math.BigDecimal;

/**
 * 提现统一入口服务
 * @Author: Paul Chan
 * @Date: 2021/4/28 下午2:09
 */
public interface ExtractCashDtoService {

  /**
   * 申请电子账户提现
   * 如果申请失败，则跑出异常，没有跑出异常，则表示提现正在处理中，等待运营平台的通知
   * @param account
   * @param amount 提现金额（元）
   * @return
   */
  ExtractCashVo extractCash(ElectronicAccount account, BigDecimal amount);

}
