package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.entity.SupplierPaymentInfo;
import com.bizunited.empower.business.payment.vo.SupplierPaymentInfoVo;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.Date;

/**
 * SupplierPaymentInfo业务模型的服务层接口定义
 *
 * @author Keller
 */
public interface SupplierPaymentInfoService {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  SupplierPaymentInfo findDetailsById(String id);

  /**
   * 按照SupplierPaymentInfo的主键编号，查询指定的数据信息（不包括任何关联信息）
   *
   * @param id 主键
   */
  SupplierPaymentInfo findById(String id);

  /**
   * 按照应付账款流水编号进行查询
   *
   * @param paymentCode 应付账款流水编号
   */
  SupplierPaymentInfo findByPaymentCode(String paymentCode);

  /**
   * 按照关联单编号进行查询
   *
   * @param associatedCode 关联单
   */
  SupplierPaymentInfo findByAssociatedCode(String associatedCode);

  /**
   * 应付账款查询列表 (按照关联单据)
   *
   * @param pageable
   * @param conditions
   */
  Page<SupplierPaymentInfoVo> findByConditionsForAssociated(Pageable pageable, InvokeParams conditions);

  /**
   * 根据订单创建应付账款
   *
   * @param supplierCode   供应商编号
   * @param supplierName   供应商名称
   * @param associatedCode 关联单据号
   * @param amount         金额
   */
  SupplierPaymentInfo createByAssociatedCode(String supplierCode, String supplierName, String associatedCode, BigDecimal amount);


  /**
   * 确认付款
   *
   * @param payCode 采购应付账款单号
   * @return
   */
  SupplierPaymentInfo confirmPay(String payCode, Date payTime);

  /**
   * 根据管理单号取消采购应付单
   *
   * @param associatedCode
   */
  void cancelByAssociatedCode(String associatedCode);

  /**
   * 根据付款单号取消采购应付单
   *
   * @param paymentCode
   */
  void cancelByPaymentCode(String paymentCode);
}
