package com.bizunited.empower.business.payment.service;

import com.bizunited.empower.business.payment.entity.SupplierReceivableInfo;
import com.bizunited.empower.business.payment.vo.SupplierReceivableInfoVo;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * SupplierReceivableInfo业务模型的服务层接口定义
 *
 * @author Keller
 */
public interface SupplierReceivableInfoService {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  SupplierReceivableInfo findDetailsById(String id);

  /**
   * 按照ReceivableInfo的主键编号，查询指定的数据信息（不包括任何关联信息）
   *
   * @param id 主键
   */
  SupplierReceivableInfo findById(String id);

  /**
   * 按照应收账款流水编号进行查询
   *
   * @param receivableCode 应收账款流水编号
   */
  SupplierReceivableInfo findByReceivableCode(String receivableCode);

  /**
   * 按照关联单编号进行查询
   *
   * @param associatedCode 关联单
   */
  SupplierReceivableInfo findByAssociatedCode(String associatedCode);

  /**
   * 按照集合关联单编号进行查询
   *
   * @param associatedCodes 关联单集合
   */
  List<SupplierReceivableInfo> findByAssociatedCodes(Set<String> associatedCodes);

  /**
   * 应收账款查询列表 (按照关联单据)
   *
   * @param pageable
   * @param conditions
   */
  Page<SupplierReceivableInfoVo> findByConditionsForAssociated(Pageable pageable, InvokeParams conditions);

  /**
   * 确认收款
   *
   * @param receivableCode 应收账款单号
   * @param receivableTime 收款时间
   * @return
   */
  SupplierReceivableInfo confirmReceive(String receivableCode, Date receivableTime);

  /**
   * 通过供应商编号以及供应商名称创建供应商应收账款
   *
   * @param supplierCode
   * @param supplierName
   * @param associatedCode
   * @param amount
   * @return
   */
  SupplierReceivableInfo createByAssociatedCode(String supplierCode, String supplierName, String associatedCode, BigDecimal amount);

  /**
   * 根据管理单号取消采购应付单
   *
   * @param associatedCode
   */
  void cancelByAssociatedCode(String associatedCode);

  /**
   * 根据付款单号取消采购应付单
   *
   * @param receivableCode
   */
  void cancelByReceivableCode(String receivableCode);
}
