package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState;
import com.bizunited.empower.business.payment.service.ElectronicAccountService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Set;

/**
 * 电子账户状态处理抽象类
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午11:10
 */
public abstract class AbstractAccountApplyStateHandle implements AccountApplyStateHandle {

  @Autowired
  protected ElectronicAccountService electronicAccountService;

  /**
   * 验证申请状态
   * @param beforeState 变更前状态
   * @param applyState 变更目标状态
   * @param allowBeforeApplyStates
   */
  protected void validApplyState(Integer beforeState, Integer applyState, Set<ElectronicAccountApplyState> allowBeforeApplyStates) {
    ElectronicAccountApplyState beforeStateEnum = ElectronicAccountApplyState.valueOfState(beforeState);
    ElectronicAccountApplyState applyStateEnum = ElectronicAccountApplyState.valueOfState(applyState);
    Validate.notNull(applyState, "不支持的更新状态：%s", applyState);
    Validate.isTrue(applyState.equals(this.getState()), "当前处理器不适合当前状态：%s", applyState);
    Validate.isTrue(allowBeforeApplyStates.contains(beforeStateEnum), "申请状态不能从【%s】变更到【%s】", beforeStateEnum.getDesc(), applyStateEnum.getDesc());
  }

}
