package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

import java.util.Date;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.END;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.INTO_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.INTO_ING;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.SIGN_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_INTO;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_SIGN;

/**
 * 已启用
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:50
 */
@Component
public class AccountApplyEndStateHandle extends AbstractAccountApplyStateHandle {

  @Override
  public int getState() {
    return END.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_INTO, INTO_ING, INTO_FAILURE, WAIT_SIGN, SIGN_FAILURE, END));
    if(!electronicAccount.getApplyState().equals(END.getState())) {
      electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
      electronicAccountService.updateTimesById(electronicAccount.getId(), null, null
          , null, new Date(), electronicAccountDto.getExpireTime());
      electronicAccountService.updateMerchantInfoById(electronicAccount.getId(), electronicAccountDto.getMerchantCode(), electronicAccountDto.getMerchantName(), electronicAccountDto.getBillingCycle());
    }
    electronicAccountService.updateTiedCardStatusById(electronicAccount.getId(), electronicAccountDto.getTiedCardStatus());
    if(electronicAccountDto.getState() != null
      && !electronicAccount.getState().equals(electronicAccountDto.getState())) {
      electronicAccountService.updateStateById(electronicAccount.getId(), electronicAccountDto.getState());
    }
  }
}
