package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.INTO_ING;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_INTO;

/**
 * 进件中
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:49
 */
@Component
public class AccountApplyIntoingStateHandle extends AbstractAccountApplyStateHandle {
  @Override
  public int getState() {
    return INTO_ING.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_INTO));
    electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
  }
}
