package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.OPEN_ACCOUNT_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.OPEN_ACCOUNT_ING;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_OPEN_ACCOUNT;

/**
 * 开户失败
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:44
 */
@Component
public class AccountApplyOpenAccountFailureStateHandle extends AbstractAccountApplyStateHandle {
  @Override
  public int getState() {
    return OPEN_ACCOUNT_FAILURE.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_OPEN_ACCOUNT, OPEN_ACCOUNT_ING));
    electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
  }
}
