package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.OPEN_ACCOUNT_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.OPEN_ACCOUNT_ING;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_OPEN_ACCOUNT;


/**
 * 17：开户中
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:44
 */
@Component
public class AccountApplyOpenAccountingStateHandle extends AbstractAccountApplyStateHandle {
  @Override
  public int getState() {
    return OPEN_ACCOUNT_ING.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_OPEN_ACCOUNT, OPEN_ACCOUNT_FAILURE));
    electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
    electronicAccountService.updateMerchantInfoById(electronicAccount.getId(), electronicAccountDto.getMerchantCode(), electronicAccountDto.getMerchantName(), electronicAccountDto.getBillingCycle());
  }
}
