package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

import java.util.Date;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.PRE_APPLY_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.PRE_APPLY_SUCCESS;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_PRE_APPLY;

/**
 * 预审成功
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:27
 */
@Component
public class AccountApplyPreApplySuccessStateHandle extends AbstractAccountApplyStateHandle {
  @Override
  public int getState() {
    return PRE_APPLY_SUCCESS.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_PRE_APPLY, PRE_APPLY_FAILURE));
    electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
    electronicAccountService.updateTimesById(electronicAccount.getId(), new Date(),
        null, null, null, null);
    electronicAccountService.updateUserIdById(electronicAccount.getId(), electronicAccount.getUserId());
  }
}
