package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.TIED_CARD_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_TIED_CARD;

/**
 * 绑卡失败
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:46
 */
@Component
public class AccountApplyTiedCardFailureStateHandle extends AbstractAccountApplyStateHandle {
  @Override
  public int getState() {
    return TIED_CARD_FAILURE.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_TIED_CARD));
    electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
  }
}
