package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.VERIFY_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_VERIFY;

/**
 * 验证失败
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:47
 */
@Component
public class AccountApplyVerifyFailureStateHandle extends AbstractAccountApplyStateHandle {
  @Override
  public int getState() {
    return VERIFY_FAILURE.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_VERIFY));
    electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
  }
}
