package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.common.enums.ElectronicAccountType;
import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import java.util.Date;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.COLLECT_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.PRE_APPLY_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.PRE_APPLY_SUCCESS;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.VERIFY_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_OPEN_ACCOUNT;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_PRE_APPLY;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_VERIFY;

/**
 * 待开户
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:29
 */
@Component
public class AccountApplyWaitOpenAccountStateHandle extends AbstractAccountApplyStateHandle {

  @Override
  public int getState() {
    return WAIT_OPEN_ACCOUNT.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    if(ElectronicAccountType.INDIVIDUAL.getType().equals(electronicAccount.getType())) {
      super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_VERIFY, VERIFY_FAILURE));
      electronicAccountService.updateTimesById(electronicAccount.getId(), null, new Date()
          , null, null, null);
    } else {
      super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_PRE_APPLY, PRE_APPLY_FAILURE, PRE_APPLY_SUCCESS, COLLECT_FAILURE));
      electronicAccountService.updateTimesById(electronicAccount.getId(), new Date(), new Date()
          , null, null, null);
      electronicAccountService.updateUserIdById(electronicAccount.getId(), electronicAccountDto.getUserId());
    }
    electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
  }

}
